<?php $__env->startSection('title', 'Edit Blog'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Edit Blog</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="edit-form" action="<?php echo e(route('blog.update', $blog->id)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="md-form">
                                    <label for="">Title</label> <span style="color: red;">*</span>
                                    <input type="text" name="title" value="<?php echo e($blog->title); ?>"
                                        class="form-control">
                                </div>


                                <div class="md-form">
                                    <label for="">Content</label>
                                    <textarea name="description" id=""
                                        class="md-textarea form-control"><?php echo e($blog->description); ?></textarea>
                                </div>


                                <div class="form-group">
                                    <label for="">Categories</label>
                                    <?php echo e(Form::select('blogcategories[]', $category, null, ["class" => 'form-control select-ninja', 'multiple' => 'multiple'])); ?>

                                </div>


                                <div class="form-group">
                                    <label for="profile_img">Feature Image</label>
                                    <input type="file" name="picture" id="picture" class="form-control p-1">
                                    <div class="preview_img my-2">
                                        <?php if($blog->picture): ?>
                                            <img src="<?php echo e($blog->blogimage_path()); ?>" alt="">
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="">Status</label>
                                    <select name="status" class="form-control">
                                        <option value="Public" <?php if($blog->status == 'Public'): ?> selected <?php endif; ?>>Public</option>
                                        <option value="Draft" <?php if($blog->status == 'Draft'): ?> selected <?php endif; ?>>Draft
                                        </option>
                                    </select>
                                </div>

                                <div class="d-flex justify-content-center mt-5 mb-3">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\UpdateBlog', '#edit-form'); ?>

    <script src="<?php echo e(asset('ckeditor/ckeditor.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('.select-ninja').select2().val(<?php echo json_encode($blog->blogcategories()->allRelatedIds()); ?>).trigger('change');

            var editor = CKEDITOR.replace('description', {
                filebrowserBrowseUrl: '../../../editor/ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '../../../editor/ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '../../../editor/ckfinder/ckfinder.html?type=Flash',
                filebrowserUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                filebrowserImageUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                filebrowserFlashUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash',
                extraPlugins: 'emoji',
            });

            $('#picture').on('change', function() {
                var file_lenght = document.getElementById('picture').files.length;
                $('.preview_img').html('');
                for (var i = 0; i < file_lenght; i++) {
                    $('.preview_img').append(`<img src="${URL.createObjectURL(event.target.files[i])}"/>`);
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/admins/blog/edit.blade.php ENDPATH**/ ?>