<?php $__env->startSection('title', 'Blog Categories'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Categories
                        <a href="<?php echo e(route('blogcategory.create')); ?>" class="btn btn-outline-primary btn-sm"><i
                                class="fas fa-plus-circle"></i> Create Category</a>
                    </h5>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-bordered Datatable" style="width: 100%">
                                <thead>
                                    <th class="text-center no-sort no-search"></th>
                                    <th class="text-center">Name</th>
                                    <th class="text-center no-sort no-search">Action</th>
                                    <th class="text-center hidden">Updated at</th>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.Datatable').DataTable({
                responsive: true,
                processing: true,
                serverSide: true,
                mark: true,
                ajax: '/admin/blogcategory/datatable/ssd',
                columns: [{
                        data: 'plus-icon',
                        name: 'plus-icon',
                        class: 'text-center'
                    },
                    {
                        data: 'name',
                        name: 'name',
                        class: 'text-center'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        class: 'text-center'
                    },
                    {
                        data: 'updated_at',
                        name: 'updated_at',
                        class: 'text-center'
                    },
                ],
                language: {
                    "paginate": {
                        "previous": "<i class='far fa-arrow-alt-circle-left'></i>",
                        "next": "<i class='far fa-arrow-alt-circle-right'></i>",
                    },
                    "processing": "<img src='/img/slplogo.png' style='width: 150px;'/><p>ခေတ္တစောင့်ဆိုင်းပါ...</p>",
                },
                columnDefs: [
                    {
                        "targets": [0],
                        "class": "control"
                    },
                    {
                        "targets": 'no-sort',
                        "orderable": false
                    },
                    {
                        "targets": 'no-search',
                        "searchable": false
                    },
                    {
                        "targets": 'hidden',
                        "visible": false
                    }
                ],
            });

            $(document).on('click', '.delete-btn', function(e) {
                e.preventDefault();

                var id = $(this).data('id');
                swal({
                        text: "Are you sure you want to delete!",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            $.ajax({
                                method: "DELETE",
                                url: `/admin/blogcategory/${id}`,
                            }).done(function(res) {
                                $('.Datatable').DataTable().ajax.reload();
                            });
                        }
                    });
            });
        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/admins/blogcategory/index.blade.php ENDPATH**/ ?>