<?php $__env->startSection('title', 'Profile'); ?>

<?php $__env->startSection('content'); ?>


    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Profile</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active"><?php echo e(Auth::user()->name); ?> Profile</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                    <div class="text-center pt-4">
                        <img src="<?php echo e(Auth::user()->profile_img_path()); ?>" alt="" class="profile-img">
                        <div class="py-3 px-2">
                            <h4><?php echo e(Auth::user()->name); ?></h4>
                            <p><span class="text-muted"><?php echo e(Auth::user()->employee_id); ?></span> | <span
                                    class="text-theme"><?php echo e(Auth::user()->phone); ?></span></p>
                            <p class="text-muted"><span
                                    class="badge badge-pill badge-dark border"><?php echo e(Auth::user()->department ? Auth::user()->department->title : '_'); ?></span>
                            </p>
                            <p class="text-muted">
                                <?php $__currentLoopData = Auth::user()->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span
                                        class="badge badge-pill badge-primary border"><?php echo e($role->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    </div>
                    </div>

                </div>
                <!-- /.col -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header p-2">
                            <ul class="nav nav-pills">
                                <li class="nav-item"><a class="nav-link" href="#personal_info"
                                        data-toggle="tab">Personal Information</a></li>
                                <li class="nav-item"><a class="nav-link active" href="#change_password"
                                        data-toggle="tab">Change Password</a></li>
                            </ul>
                        </div><!-- /.card-header -->
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane" id="personal_info">
                                    <form class="form-horizontal" method="POST" action="<?php echo e(route('adminUpdateInfo')); ?>"
                                        id="AdminInfoForm">
                                        <div class="md-form">
                                            <label for="">Employee ID</label>
                                            <input type="text" name="employee_id" value="<?php echo e(Auth::user()->employee_id); ?>"
                                                class="form-control" disabled>
                                        </div>
                                        <div class="md-form">
                                            <label for="">Name</label>
                                            <input type="text" name="name" value="<?php echo e(Auth::user()->name); ?>" class="form-control">
                                        </div>

                                        <div class="md-form">
                                            <label for="">Phone</label>
                                            <input type="number" name="phone" value="<?php echo e(Auth::user()->phone); ?>"
                                                class="form-control">
                                        </div>

                                        <div class="md-form">
                                            <label for="">Email</label>
                                            <input type="email" name="email" value="<?php echo e(Auth::user()->email); ?>"
                                                class="form-control">
                                        </div>

                                        <div class="md-form">
                                            <label for="">NRC Number</label>
                                            <input type="text" name="nrc_number" value="<?php echo e(Auth::user()->nrc_number); ?>"
                                                class="form-control">
                                        </div>

                                        <div class="form-group">
                                            <label for="">Gender</label>
                                            <select name="gender" class="form-control">
                                                <option value="male" <?php if(Auth::user()->gender == 'male'): ?> selected <?php endif; ?>>Male</option>
                                                <option value="female" <?php if(Auth::user()->gender == 'female'): ?> selected <?php endif; ?>>Female
                                                </option>
                                            </select>
                                        </div>

                                        <div class="md-form">
                                            <label for="">Birthday</label>
                                            <input type="text" name="birthday" value="<?php echo e(Auth::user()->birthday); ?>"
                                                class="form-control birthday">
                                        </div>

                                        <div class="md-form">
                                            <label for="">Address</label>
                                            <textarea name="address" id=""
                                                class="md-textarea form-control"><?php echo e(Auth::user()->address); ?></textarea>
                                        </div>

                                        <div class="form-group">
                                            <label for="profile_img">Profile Image</label>
                                            <input type="file" name="profile_img" id="profile_img" class="form-control p-1">
                                            <div class="preview_img my-2">
                                                <?php if(Auth::user()->profile_img): ?>
                                                    <img src="<?php echo e(Auth::user()->profile_img_path()); ?>" alt="">
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group">

                                                <button type="submit" class="btn btn-danger">Save Changes</button>

                                        </div>
                                    </form>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="active tab-pane" id="change_password">
                                    <form class="form-horizontal" action="<?php echo e(route('adminChangePassword')); ?>"
                                        method="POST" id="changePasswordAdminForm">
                                        <div class="form-group row">
                                            <label for="inputName" class="col-sm-2 col-form-label">Old Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" id="inputName"
                                                    placeholder="Enter current password" name="oldpassword">
                                                <span class="text-danger error-text oldpassword_error"></span>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="inputName2" class="col-sm-2 col-form-label">New Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" id="newpassword"
                                                    placeholder="Enter new password" name="newpassword">
                                                <span class="text-danger error-text newpassword_error"></span>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="inputName2" class="col-sm-2 col-form-label">Confirm New
                                                Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" id="cnewpassword"
                                                    placeholder="ReEnter new password" name="cnewpassword">
                                                <span class="text-danger error-text cnewpassword_error"></span>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="offset-sm-2 col-sm-10">
                                                <button type="submit" class="btn btn-danger">Update Password</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.tab-content -->
                        </div><!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.birthday').daterangepicker({
                "singleDatePicker": true,
                "autoApply": true,
                "showDropdowns": true,
                "maxDate": moment(),
                "locale": {
                    "format": "YYYY-MM-DD",
                }
            });

            $('.date_of_join').daterangepicker({
                "singleDatePicker": true,
                "autoApply": true,
                "showDropdowns": true,
                "locale": {
                    "format": "YYYY-MM-DD",
                }
            });

            $('#profile_img').on('change', function() {
                var file_lenght = document.getElementById('profile_img').files.length;
                $('.preview_img').html('');
                for (var i = 0; i < file_lenght; i++) {
                    $('.preview_img').append(`<img src="${URL.createObjectURL(event.target.files[i])}"/>`);
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\su\resources\views/dashboards/admins/profile.blade.php ENDPATH**/ ?>