<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Edit User</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="edit-form" action="<?php echo e(route('employee.update', $employee->id)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="md-form">
                                    <label for="">Employee ID</label>
                                    <input type="text" name="employee_id" value="<?php echo e($employee->employee_id); ?>"
                                        class="form-control">
                                </div>
                                <div class="md-form">
                                    <label for="">Name</label>
                                    <input type="text" name="name" value="<?php echo e($employee->name); ?>" class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">Phone</label>
                                    <input type="number" name="phone" value="<?php echo e($employee->phone); ?>"
                                        class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">Email</label>
                                    <input type="email" name="email" value="<?php echo e($employee->email); ?>"
                                        class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">NRC Number</label>
                                    <input type="text" name="nrc_number" value="<?php echo e($employee->nrc_number); ?>"
                                        class="form-control">
                                </div>

                                <div class="form-group">
                                    <label for="">Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="male" <?php if($employee->gender == 'male'): ?> selected <?php endif; ?>>Male</option>
                                        <option value="female" <?php if($employee->gender == 'female'): ?> selected <?php endif; ?>>Female
                                        </option>
                                    </select>
                                </div>

                                <div class="md-form">
                                    <label for="">Birthday</label>
                                    <input type="text" name="birthday" value="<?php echo e($employee->birthday); ?>"
                                        class="form-control birthday">
                                </div>

                                <div class="md-form">
                                    <label for="">Address</label>
                                    <textarea name="address" id=""
                                        class="md-textarea form-control"><?php echo e($employee->address); ?></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="">Department</label>
                                    <select name="department_id" class="form-control">
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($department->id); ?>"
                                                <?php if($employee->department_id == $department->id): ?> selected <?php endif; ?>><?php echo e($department->title); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="">Role (or) Designation</label>
                                    <select name="roles[]" class="form-control select-ninja" multiple>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->name); ?>"
                                                <?php if(in_array($role->id, $old_roles)): ?> selected <?php endif; ?>><?php echo e($role->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="md-form">
                                    <label for="">Date of Join</label>
                                    <input type="text" name="date_of_join" value="<?php echo e($employee->date_of_join); ?>"
                                        class="form-control date_of_join">
                                </div>

                                <div class="form-group">
                                    <label for="">Is Present?</label>
                                    <select name="is_present" class="form-control">
                                        <option value="1" <?php if($employee->is_present == 1): ?> selected <?php endif; ?>>YES</option>
                                        <option value="0" <?php if($employee->is_present == 0): ?> selected <?php endif; ?>>NO</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="profile_img">Profile Image</label>
                                    <input type="file" name="profile_img" id="profile_img" class="form-control p-1">
                                    <div class="preview_img my-2">
                                        <?php if($employee->profile_img): ?>
                                            <img src="<?php echo e($employee->profile_img_path()); ?>" alt="">
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="md-form">
                                    <label for="">Password</label>
                                    <input type="password" name="password" class="form-control">
                                </div>

                                <div class="d-flex justify-content-center mt-5 mb-3">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\UpdateEmployee', '#edit-form'); ?>

    <script>
        $(document).ready(function() {
            $('.birthday').daterangepicker({
                "singleDatePicker": true,
                "autoApply": true,
                "showDropdowns": true,
                "maxDate": moment(),
                "locale": {
                    "format": "YYYY-MM-DD",
                }
            });

            $('.date_of_join').daterangepicker({
                "singleDatePicker": true,
                "autoApply": true,
                "showDropdowns": true,
                "locale": {
                    "format": "YYYY-MM-DD",
                }
            });

            $('#profile_img').on('change', function() {
                var file_lenght = document.getElementById('profile_img').files.length;
                $('.preview_img').html('');
                for (var i = 0; i < file_lenght; i++) {
                    $('.preview_img').append(`<img src="${URL.createObjectURL(event.target.files[i])}"/>`);
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/admins/employee/edit.blade.php ENDPATH**/ ?>