<?php $__env->startSection('title', 'Edit Plan'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Edit Plan</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="edit-form" action="<?php echo e(route('plan.update', $plan->id)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="md-form">
                                    <label for="">Plan Name</label> <span style="color: red;">*</span>
                                    <input type="text" name="plan_name" value="<?php echo e($plan->plan_name); ?>"
                                        class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">Bandwidth</label> <span style="color: red;">*</span>
                                    <input type="text" name="bandwidth" value="<?php echo e($plan->bandwidth); ?>"
                                        class="form-control">
                                </div>

                                <div class="form-group mt-4">
                                    <input type="hidden" name="recommand" value="0">
                                    <input type="checkbox" name="recommand" value="1"
                                    <?php echo e($plan->recommand || old('recommand', 0) === 1 ? 'checked' : 'unchecked'); ?>>
                                    <label class="form-check-label" for="recommand">‌Recommanded</label>
                                </div>

                                <div class="form-group mt-4">
                                    <input type="hidden" name="large" value="0">
                                    <input type="checkbox" name="large" value="1"
                                    <?php echo e($plan->large || old('large', 0) === 1 ? 'checked' : 'unchecked'); ?>>
                                    <label class="form-check-label" for="large">‌Large Campus</label>
                                </div>

                                <div class="form-group">
                                    <label for="">Service Area</label>
                                    <select name="servicea_id" class="form-control">
                                        <?php $__currentLoopData = $servicearea; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($sa->id); ?>"
                                                <?php if($plan->servicea_id == $sa->id): ?> selected <?php endif; ?>><?php echo e($sa->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="md-form">
                                    <label for="">Content</label>
                                    <textarea name="description" id=""
                                        class="md-textarea form-control"><?php echo e($plan->description); ?></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="">Status</label>
                                    <select name="status" class="form-control">
                                        <option value="Public" <?php if($plan->status == 'Public'): ?> selected <?php endif; ?>>Public</option>
                                        <option value="Draft" <?php if($plan->status == 'Draft'): ?> selected <?php endif; ?>>Draft
                                        </option>
                                    </select>
                                </div>

                                <div class="d-flex justify-content-center mt-5 mb-3">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\UpdatePlan', '#edit-form'); ?>

    <script src="<?php echo e(asset('ckeditor/ckeditor.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            var editor = CKEDITOR.replace('description', {
                filebrowserBrowseUrl: '../../../editor/ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '../../../editor/ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '../../../editor/ckfinder/ckfinder.html?type=Flash',
                filebrowserUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                filebrowserImageUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                filebrowserFlashUploadUrl: '../../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash',
                extraPlugins: 'emoji',
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/admins/plan/edit.blade.php ENDPATH**/ ?>