@extends('dashboards.users.layouts.user-dash-layout')
@section('title','Home')

@section('content')
<div id="particles-js">
    <div style="position: absolute;">
      <header>

        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <img src="{{ asset('frontimages/motc.png') }}" width="75" height="75" class="d-inline-block align-top" alt="">
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse"
                    data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item active">
                            <a class="nav-link" href="{{ url('/') }}">Home <span class="sr-only">(current)</span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ url('rooms') }}">All Rooms</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ url('rank-for-ncsc') }}">LeaderBoards</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{url('teaching-rooms')}}">Teaching</a>
                        </li>
                        <!-- <li class="nav-item">
                            <a class="nav-link" href="{{url('teaching-rooms')}}">Write-Ups</a>
                        </li> -->
                        <!-- <li class="nav-item">
                            <a class="nav-link" href="#">About</a>
                        </li> -->
                        <!-- <li class="nav-item">
                            <a class="nav-link" href="#">Admin Panel</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Contact</a>
                        </li> -->
                        <!-- <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Dropdown
                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="#">Action</a>
                                <a class="dropdown-item" href="#">Another action</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#">Something else here</a>
                            </div>
                        </li> -->

                        @guest
                          <!-- @if (Route::has('login'))
                          <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                          </li>
                          @endif

                          @if (Route::has('register'))
                          <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                          </li>
                          @endif -->
                          @else
                          <li class="nav-item dropdown"  style="margin-top: -2px;">

                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                              <img src="{{ Auth::user()->picture }}" class="img-circle elevation-2 user-panel admin_picture" alt="User Image"> <span class="admin_name"> {{ Auth::user()->name }}</span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown" style="margin-top: -2px;">
                              
                              @if(Auth::user()->roles[0]->name == 'admin')
                              <a class="dropdown-item" href="{{ route('admin.profile')}}">
                                Profile
                              </a>
                              <a target="_blank" class="dropdown-item" href="{{ route('admin.dashboard')}}">
                                Backend Dashboard
                              </a>
                              @else
                              <a class="dropdown-item" href="{{ route('user.profile') }}">
                                Profile
                              </a>
                              <a class="dropdown-item" href="{{ route('user.profile') }}">
                                My Rooms
                              </a>
                              @endif
                              <a class="dropdown-item" href="{{ route('logout') }}"
                              onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">
                              {{ __('Logout') }}
                            </a>

                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                              @csrf
                            </form>
                          </div>
                        </li>
                        @endguest

                    </ul>
                </div>
            </div>
        </nav>
    </header>

    <!-- banner section -->

    <section class="banner">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="banner_desc">
                        <h1 class="title">Ministry Of Transport And Communication</h1>
                        <h4 class="text-primary" style="color: #fff; margin-bottom: -15px;margin-top: 30px;">
                          National Cyber Security Center
                        </h4>
                        <p class="desc">“When People aren't even aware of something yet
                        themselves, they certainly can't be aware that they're
                        disclosing that information.”
                        </p>
                        <p class="desc">
                        -Kelly Caine</p>
                        @guest
                        @if (Route::has('login'))
                        <a href="{{ route('login') }}" class="btn btn-color">LOGIN</a>
                        @endif
                        @if (Route::has('register'))
                        <a href="{{ route('register') }}" class="btn btn-trans">REGISTER</a>
                        @endif
                        @else

                        <!-- <h3 style="color: #7a7a7a;">Your now Login!</h3> -->
                        @endguest
                    </div>
                </div>
                
                <div class="col-md-6">

                </div>
              
            </div>
        </div>
    </section>
    </div>
    
</div>
    <section>
        <div class="container mt-3">
            <h2 class="mb-3">Teaching Levels</h2>
            <div class="row">
                @foreach($levels as $key=>$l)
                    @if($key == 0)
                        <div class="col-md-4 col-sm-6 content-card d-flex justify-content-center">
                            <div class="card" style="">
                              <img class="card-img-top" src="{{url('tlevel-images')}}/{{$l->cpicture}}" alt="Card image" style="width:100%; height: 230px;border-bottom: solid 5px rgba(0, 255, 72, 0.7);">
                              <h5 style="position: absolute; background: rgba(0, 255, 72, 0.7)မမမ; padding: 5px;">
                                <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" style="color: #fff;">
                                  {{$l->cattitle}}
                                </a>
                              </h5>
                              <div class="card-body">
                                <p class="text-center">
                                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. A repudiandae minima quibusdam aperiam qui natus quod quo, adipisci eveniet architecto. Laboriosam voluptatem praesentium excepturi qui temporibus eos ab. Dolor, accusantium.
                                </p>
                                <div class="text-center">
                                  <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" class="btn btn-outline-primary btn-sm">View More...</a>
                                </div>
                                
                              </div>
                            </div>
                        </div>
                    @endif
                @endforeach
                
                @foreach($levels as $key=>$l)
                    @if($key == 1)
                        <div class="col-md-4 col-sm-6 content-card d-flex justify-content-center">
                            <div class="card" style="">
                              <img class="card-img-top" src="{{url('tlevel-images')}}/{{$l->cpicture}}" alt="Card image" style="width:100%; height: 230px;border-bottom: solid 5px rgba(75, 40, 214, 0.7);">
                              <h5 style="position: absolute; background: rgba(75, 40, 214, 0.7); padding: 5px;">
                                <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" style="color: #fff;">
                                  {{$l->cattitle}}
                                </a>
                              </h5>
                              <div class="card-body">
                                <p class="text-center">
                                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. A repudiandae minima quibusdam aperiam qui natus quod quo, adipisci eveniet architecto. Laboriosam voluptatem praesentium excepturi qui temporibus eos ab. Dolor, accusantium.
                                </p>
                                <div class="text-center">
                                  <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" class="btn btn-outline-primary btn-sm">View More...</a>
                                </div>
                                
                              </div>
                            </div>
                        </div>
                    @endif
                @endforeach
                
                @foreach($levels as $key=>$l)
                    @if($key == 2)
                        <div class="col-md-4 col-sm-6 content-card d-flex justify-content-center">
                            <div class="card" style="">
                              <img class="card-img-top" src="{{url('tlevel-images')}}/{{$l->cpicture}}" alt="Card image" style="width:100%; height: 230px;border-bottom: solid 5px rgba(255, 80, 0, 0.7);">
                              <h5 style="position: absolute; background: rgba(255, 80, 0, 0.7); padding: 5px;">
                                <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" style="color: #fff;">
                                  {{$l->cattitle}}
                                </a>
                              </h5>
                              <div class="card-body">
                                <p class="text-center">
                                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. A repudiandae minima quibusdam aperiam qui natus quod quo, adipisci eveniet architecto. Laboriosam voluptatem praesentium excepturi qui temporibus eos ab. Dolor, accusantium.
                                </p>
                                <div class="text-center">
                                  <a href="{{ url('teachinglevel-rooms') }}/{{$l->slug}}" class="btn btn-outline-primary btn-sm">View More...</a>
                                </div>
                                
                              </div>
                            </div>
                        </div>
                    @endif
                @endforeach
                
            </div>
        </div>
    </section>

    <section class="reguser">
        <div class="container my-3 py-5">
            
            <div class="row">
                
                <div class="col-md-9">
                    <h3>Community</h3>
                    <p>
                        Connect with other like-minded cyber security students and join our huge community. 
                        Ask questions, share knowledge and meet people on the same journey as you.
                    </p>
                </div>
                <div class="col-md-3 text-center">

                    <h2 class="text-info">{{ $rusers }}</h2>
                    <hr class="colored">
                    <h4>Register Users</h4>
                </div>
            </div>
            
        </div>
    </section>

    <section>
        <div class="container mt-3">
            <h2 class="mb-3">All Modules</h2>
            <div class="row">
                @forelse($categories as $cat)
                <div class="col-md-4">
                  <a href="{{ url('room-category-detail') }}/{{$cat->slug}}">
                    <div class="card cat">
                        <img src="{{url('cat-images')}}/{{$cat->cpicture}}" class="card-img-top mt-3 mx-auto d-block" alt="..." style="width: 160px; height: 160px;">
                        <div class="card-body text-center">
                          <h5 class="card-title">{{$cat->cattitle}}</h5>
                          <p class="card-text">
                              {{ $cat->description }}
                          </p>
                          <!-- <a href="#" class="btn btn-primary btn-sm">Go somewhere</a> -->
                        </div>
                    </div>
                  </a>
                </div>
                @empty
                <p>No Category Found!</p>
                @endforelse
            </div>
        </div>
    </section>

    <section class="animate">
        
    </section>
    

    
@stop