@extends('dashboards.guest.layouts.guest_layout1')

@section('title', 'Service Area')

@section('content')


    <!-- ======= Breadcrumbs ======= -->
    <section id="breadcrumbs" class="breadcrumbs">
        <div class="container tagu">

            <ol>
                <li><a href="{{ route('/') }}">Home</a></li>
            </ol>
            <h5 class="tagu">Service Area: {{ $servicea->name }}</h5>

        </div>
    </section><!-- End Breadcrumbs -->

    <div class="container my-3">
        <div class="row tagu servicearea">
            <div class="col-md-12 text-center">
                <h4 class="tagu">{{ $servicea->name }}</h4>
                <p class="tagu">{!! $servicea->address !!}</p>
                <p>{{ $servicea->phone1 }}
                    @if ($servicea->phone2)
                        , {{ $servicea->phone2 }}
                    @endif
                    @if ($servicea->phone3)
                        , {{ $servicea->phone3 }}
                    @endif
                </p>
            </div>

        </div>
        <div class="row serviceplan">
            <h4 class="mb-3">Our Service Plans</h4>
            @forelse ($plans as $plan)
                <div class="col-md-4">
                    <div class="card mb-4 box-shadow text-center">
                        <div class="card-header">
                            <h4 class="my-0 font-weight-normal">{{ $plan->plan_name }}</h4>
                        </div>
                        <div class="card-body">
                            <h1 class="card-title pricing-card-title">{{ $plan->bandwidth }} Mb <small class="text-muted">/ s</small></h1>
                            {!! $plan->description !!}
                            {{--  <button type="button" class="btn btn-lg btn-block btn-outline-primary">Sign up for free</button>  --}}
                        </div>
                    </div>
                </div>
            @empty
                <p>No Service Plan Found!</p>
            @endforelse

        </div>
    </div>

    <div class="container-fluid">
        <div class="row" style="margin: 30px -30px;">
            {!! $servicea->maplink !!}
        </div>
    </div>


@endsection
