@extends('dashboards.admins.layouts.admin-dash-layout')
@section('title','NE-Partners')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
	<div class="container-fluid">
		<div class="row mb-2">
			<div class="col-sm-6">
				<h1>Partners
					<a href="{{url('admin/view-ne-partner')}}" class="btn btn-outline-primary btn-sm ml-4">New</a>
				</h1>

			</div>
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
					<li class="breadcrumb-item"><a href="#">Home</a></li>
					<li class="breadcrumb-item active">Partners</li>
				</ol>
			</div>
		</div>
	</div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">DataTable with default features</h3>
            </div> -->
            <!-- /.card-header -->
            <div class="card-body">
            	<div class="row">
            		<div class="col-md-4 cat-form">
            			@if(Session::has('message'))
            			<div class="alert alert-success alert-dismissable fadein">
            				<a href="#" class="close" data-dismiss="alert">&times;</a>
            				{{Session('message')}}
            			</div>
            			@endif
            			<h5>Edit Partner</h5>
            			<form id="update-form" method="post" action="{{url('admin/update-ne-partner')}}/{{$singledata->id}}" enctype="multipart/form-data">
            				@csrf

            				<div class="form-group">
            					<label>Name</label> <span style="color: red;">*</span>
            					<input type="text" name="ptname" id="ptname" class="form-control" value="{{$singledata->ptname}}">
            				</div>



            				<div class="form-group">
            					<label>Slug</label>
            					<input type="text" name="slug" id="slug" class="form-control" readonly="" value="{{$singledata->slug}}">
            				</div>

                                    <div class="form-group">
                                          <label>Freature Image</label> <span style="color: red;">*</span>
                                          @if(!empty($singledata->ptpicture))
                                          <p><img src="{{url('partner-images')}}/{{$singledata->ptpicture}}" id="output" width="200"></p>
                                          <p><input type="file"  accept="image/*" name="ptpicture" id="file"  onchange="loadFile(event)" style="display: none;"></p>
                                          <p><label for="file" style="cursor: pointer;" class="btn btn-warning">Replace Image</label></p>

                                          @else
                                          <p><input type="file"  accept="image/*" name="ptpicture" id="file"  onchange="loadFile(event)" style="display: none;"></p>
                                          <p><img id="output" width="200" /></p>
                                          <p><label for="file" style="cursor: pointer;" class="btn btn-warning">Upload Image</label></p>
                                          @endif
                                    </div>

            				<div class="form-group">
            					<label>Status</label>
            					<select class="form-control" name=status>
            						<option>{{$singledata->status}}</option>
            						@if($singledata->status == 'Off')
            						<option>On</option>
            						@else
            						<option>Off</option>
            						@endif
            					</select>
            				</div>

                                    <div class="form-group">
                                          <label>Remark</label>
                                          <input type="text" name="remark" id="remark" class="form-control" value="{{$singledata->remark}}">
                                    </div>
            				<div class="form-group">
            					<button class="btn btn-primary">Update Partner</button>
            				</div>
            			</form>
            		</div>

            		<div class="col-md-8 cat-view">
            			<form method="post" action="{{url('admin/multipledelete')}}">

            				@csrf
            				<input type="hidden" name="tbl" value="{{encrypt('partners') }}">
            				<input type="hidden" name="tblid" value="{{encrypt('id')}}">
            				<div class="row">
            					<div class="col-sm-3">

            						<select name="bulk-action" class="form-control">
            							<option value="0">Bulk Action</option>
            							<option value="1">Move to Trash</option>
            						</select>
            					</div>
            					<div class="col-sm-2">
            						<button class="btn btn-default">Apply</button>
            					</div>
            					<div class="col-sm-3 col-sm-offset-4">
            						<input type="text" id="search" class="form-control" placeholder="Search Partner">
            					</div>
            				</div>
            				<div class="content1">
            					<table class="table table-hover" id="category">
            						<thead>
            							<tr>
            								<th><input type="checkbox" id="select-all"> Name</th>
            								<th>Slug</th>
            								<th>Status</th>
            							</tr>
            						</thead>
            						<tbody>
            							@if(count($data) > 0)
            							@foreach($data as $partner)
            							<tr>
            								<td><input type="checkbox" name="select-data[]" value="{{$partner->id}}"><a href="{{url('admin/edit-ne-partner')}}/{{$partner->id}}"> {{$partner->ptname}}</a></td>
            								<td>{{$partner->slug}}</td>
            								<td>{{$partner->status}}</td>
            							</tr>
            							@endforeach
            							@else
            							<tr>
            								<td>No data found.</td>
            							</tr>
            							@endif
            						</tbody>
            					</table>
            				</div>
            			</form>
            		</div>
            	</div>
            </div>
        </div>
    </div>
</div>
</div>
</section>
@stop

@section('scripts')
{!! JsValidator::formRequest('App\Http\Requests\UpdatePartner', '#update-form'); !!}
<script>
      var loadFile = function(event) {
            var image = document.getElementById('output');
            image.src = URL.createObjectURL(event.target.files[0]);
      };
</script>

@stop

