<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'slug',
        'title',
        'description',
        'view_count',
        'picture',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function blogcategories()
    {
        return $this->belongsToMany('App\Models\BlogCategory','blog_category');
    }

    public function blogimage_path()
    {
        if($this->picture){
            return asset('storage/blog/' . $this->picture);
        }

        return null;
    }
}
