<?php

namespace App\Http\Controllers\user;

use App\Models\Blog;
use App\Models\ServiceA;
use App\Models\BlogCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BlogFrontController extends Controller
{
    public function __construct()
	{
		$blogcategories = BlogCategory::all();
        $latestblogs = Blog::with('blogcategories')->orderBy('id', 'DESC')->where('status', '=', 'Public')->take(5)->get();
        $serviceas = ServiceA::all();
		view()->share([
			'blogcategories' => $blogcategories,
            'latestblogs' => $latestblogs,
            'serviceas' => $serviceas,
		]);
	}

    public function index()
    {
        $blogs = Blog::with('blogcategories')->orderBy('id', 'DESC')->where('status', '=', 'Public')->paginate(10);

        return view('dashboards.guest.blog.index', compact('blogs'));
    }

    public function categorybyblog($slug)
    {
        $cat = BlogCategory::whereSlug($slug)->firstOrFail();

        $blogs = $cat->blogs()->orderBy('id', 'DESC')->where('status', '=', 'Public')->paginate(10);

        return view('dashboards.guest.blog.index', compact('blogs', 'cat'));
    }

    public function show($slug)
    {
        $blog = Blog::with('blogcategories')->whereSlug($slug)->firstOrFail();

        return view('dashboards.guest.blog.show', compact('blog'));
    }

    public function search(Request $request){
        $keyword = $request->input('s');

        $blogs= Blog::with('blogcategories')->where(function($blog) use($keyword){
        	if(!empty($keyword)){
                $blog->where('title', 'like', '%'.$keyword.'%')
                ->orwhere('description', 'like','%'.$keyword.'%');
            }
        })

        ->get();
            // dd($jobs);
        return view('dashboards.guest.blog.search',compact('blogs'));
    }
}
