<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePlan;
use App\Http\Requests\UpdatePlan;
use App\Models\Plan;
use App\Models\ServiceA;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Storage;

class PlanController extends Controller
{
    public function index()
    {
        if(!auth()->user()->can('view_service_plan')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.plan.index');
    }

    public function ssd(Request $request)
    {
        if(!auth()->user()->can('view_service_plan')) {
            abort(403, 'Unauthorized Action');
        }

        $plan = Plan::with('servicearea');

        return Datatables::of($plan)
            ->filterColumn('servicearea', function($query, $keyword) {
                $query->whereHas('servicearea', function($q1) use ($keyword) {
                    $q1->where('name', 'like', '%'.$keyword.'%');
                });
            })
            ->editColumn('bandwidth', function($each) {
                return $each->bandwidth. 'Mb/<small>s</small>';
            })
            ->addColumn('servicearea_name', function($each){
                return $each->servicearea ? $each->servicearea->name : '-';
            })
            ->editColumn('description', function($each) {
                return Str::limit($each->description, 300);
            })
            ->editColumn('updated_at', function($each) {
                return Carbon::parse($each->updated_at)->format('Y-m-d H:i:s');
            })
            ->addColumn('action', function($each) {
                $edit_icon = '<a href="' . route('plan.edit', $each->id) . '" class="text-warning"><i class="far fa-edit"></i></a>';
                $info_icon = '<a href="' . route('plan.show', $each->id) . '" class="text-primary"><i class="fas fa-info-circle"></i></a>';
                $delete_icon = '<a href="#" class="text-danger delete-btn" data-id="'. $each->id .'"><i class="fas fa-trash-alt"></i></a>';

                return '<div class="action-icon">' . $edit_icon . $info_icon . $delete_icon.'</div>';
            })
            ->addColumn('plus-icon', function($each) {
                return null;
            })
            ->rawColumns(['bandwidth', 'description', 'action'])
            ->make(true);
    }

    public function create()
    {
        if(!auth()->user()->can('create_service_plan')) {
            abort(403, 'Unauthorized Action');
        }

        $servicearea = ServiceA::all();
        return view('dashboards.admins.plan.create', compact('servicearea'));
    }

    public function store(StorePlan $request)
    {
        if(!auth()->user()->can('create_service_plan')) {
            abort(403, 'Unauthorized Action');
        }

        $user_id = auth()->user()->id;

        $slug = uniqid();

        $plan = new Plan();
        $plan->user_id = $user_id;
        $plan->slug = $slug;
        $plan->plan_name = $request->plan_name;
        $plan->bandwidth = $request->bandwidth;
        $plan->recommand = $request->recommand;
        $plan->large = $request->large;
        $plan->servicea_id = $request->servicea_id;
        $plan->description = $request->description;
        $plan->status = $request->status;
        $plan->save();

        return redirect()->route('plan.index')->with('create', 'Service plan is successfully Create!');
    }

    public function edit($id)
    {
        if(!auth()->user()->can('edit_service_plan')) {
            abort(403, 'Unauthorized Action');
        }

        $plan = Plan::findOrFail($id);
        $servicearea = ServiceA::all();

        return view('dashboards.admins.plan.edit', compact('plan', 'servicearea'));
    }
    public function update($id, UpdatePlan $request)
    {
        if(!auth()->user()->can('edit_user')) {
            abort(403, 'Unauthorized Action');
        }

        $plan = Plan::findOrFail($id);

        $plan->plan_name = $request->plan_name;
        $plan->bandwidth = $request->bandwidth;
        $plan->recommand = $request->recommand;
        $plan->large = $request->large;
        $plan->servicea_id = $request->servicea_id;
        $plan->description = $request->description;
        $plan->status = $request->status;
        $plan->update();

        return redirect()->route('plan.index')->with('update', 'Service plan is successfully Update!');
    }

    public function show($id)
    {
        if(!auth()->user()->can('view_service_plan')) {
            abort(403, 'Unauthorized Action');
        }
        $plan = Plan::findOrFail($id);
        return view('dashboards.admins.plan.show', compact('plan'));
    }

    public function destroy($id)
    {
        if(!auth()->user()->can('delete_service_plan')) {
            abort(403, 'Unauthorized Action');
        }
        $plan = Plan::findOrFail($id);
        $plan->delete();
        return 'success';
    }
}
