<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Department;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Requests\StoreDepartment;
use App\Http\Requests\UpdateDepartment;

class DepartmentController extends Controller
{

    public function index()
    {
        if(!auth()->user()->can('view_department')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.department.index');
    }

    public function ssd(Request $request)
    {
        if(!auth()->user()->can('view_department')) {
            abort(403, 'Unauthorized Action');
        }

        $department = Department::query();

        return Datatables::of($department)
            ->editColumn('updated_at', function($each) {
                return Carbon::parse($each->updated_at)->format('Y-m-d H:i:s');
            })
            ->addColumn('action', function($each) {
                $edit_icon = '<a href="' . route('department.edit', $each->id) . '" class="text-warning"><i class="far fa-edit"></i></a>';
                $delete_icon = '<a href="#" class="text-danger delete-btn" data-id="'. $each->id .'"><i class="fas fa-trash-alt"></i></a>';

                return '<div class="action-icon">' . $edit_icon . $delete_icon.'</div>';
            })
            ->addColumn('plus-icon', function($each) {
                return null;
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function create()
    {
        if(!auth()->user()->can('create_department')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.department.create');
    }

    public function store(StoreDepartment $request)
    {
        if(!auth()->user()->can('create_department')) {
            abort(403, 'Unauthorized Action');
        }
        $department = new Department();
        $department->title = $request->title;
        $department->save();

        return redirect()->route('department.index')->with('create', 'Department is successfully Create!');
    }

    public function edit($id)
    {
        if(!auth()->user()->can('edit_department')) {
            abort(403, 'Unauthorized Action');
        }
        $department = Department::findOrFail($id);
        return view('dashboards.admins.department.edit', compact('department'));
    }

    public function update($id, UpdateDepartment $request)
    {
        if(!auth()->user()->can('edit_department')) {
            abort(403, 'Unauthorized Action');
        }

        $department = Department::findOrFail($id);

        $department->title = $request->title;
        $department->update();

        return redirect()->route('department.index')->with('update', 'Department is successfully Update!');
    }


    public function destroy($id)
    {
        if(!auth()->user()->can('delete_department')) {
            abort(403, 'Unauthorized Action');
        }

        $department = Department::findOrFail($id);
        $department->delete();

        return 'success';
    }
}
