<?php

namespace App\Http\Controllers;

use Auth;
use App\Models\Kl;
use Carbon\Carbon;
use App\Models\Land;
use App\Models\Room;
use App\Models\User;
use App\Models\Category;
use App\Models\Sd;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AdminController extends Controller
{

  function index(){
    $l = Land::with('lt','lta', 'la','ts','sr', 'pl', 'landimages')->orderBy('id', 'desc')->take(5)->get();
    $kl = Kl::with('kcs')->orderBy('id', 'desc')->take(5)->get();
    $sd = Sd::with('dcs')->orderBy('id', 'desc')->take(5)->get();
    return view('dashboards.admins.index', compact('l', 'kl', 'sd'));
  }

  function profile(){
    if(!auth()->user()->can('view_profile')) {
        abort(403, 'Unauthorized Action');
    }

   return view('dashboards.admins.profile');
 }

 function updateInfo(Request $request){
    if(!auth()->user()->can('edit_profile')) {
        abort(403, 'Unauthorized Action');
    }

   $validator = \Validator::make($request->all(),[
     'name'=>'required',
     'email'=> 'required|email|unique:users,email,'.auth()->user()->id,
   ]);

   if(!$validator->passes()){
     return response()->json(['status'=>0,'error'=>$validator->errors()->toArray()]);
   }else{

    $profile_img_name = auth()->user()->profile_img;
        if($request->hasFile('profile_img')) {

            Storage::disk('public')->delete('employee/' . auth()->user()->profile_img);

            $profile_img_file = $request->file('profile_img');
            $profile_img_name = uniqid(). '_' . time() . '.' . $profile_img_file->getClientOriginalExtension();
            Storage::disk('public')->put('employee/'. $profile_img_name, file_get_contents($profile_img_file));
        }
    $query = User::findOrFail(auth()->user()->id)->update([
     'name'=>$request->name,
     'email'=>$request->email,
    'phone' => $request->phone,
    'nrc_number' => $request->nrc_number,
    'gender' => $request->gender,
    'birthday' => $request->birthday,
    'address' => $request->address,
    'profile_img' => $profile_img_name,
   ]);

    if(!$query){
      return response()->json(['status'=>0,'msg'=>'Something went wrong.']);
    }else{
      return response()->json(['status'=>1,'msg'=>'Your profile info has been update successfuly.']);
    }
  }
}

function updatePicture(Request $request){
    if(!auth()->user()->can('edit_profile')) {
        abort(403, 'Unauthorized Action');
    }
 $path = 'users/images/';
 $file = $request->file('admin_image');
 $new_name = 'UIMG_'.date('Ymd').uniqid().'.jpg';

           //Upload new image
 $upload = $file->move(public_path($path), $new_name);

 if( !$upload ){
   return response()->json(['status'=>0,'msg'=>'Something went wrong, upload new picture failed.']);
 }else{
               //Get Old picture
   $oldPicture = User::find(Auth::user()->id)->getAttributes()['picture'];

   if( $oldPicture != '' ){
     if( \File::exists(public_path($path.$oldPicture))){
       \File::delete(public_path($path.$oldPicture));
     }
   }

               //Update DB
   $update = User::find(Auth::user()->id)->update(['picture'=>$new_name]);

   if( !$upload ){
     return response()->json(['status'=>0,'msg'=>'Something went wrong, updating picture in db failed.']);
   }else{
     return response()->json(['status'=>1,'msg'=>'Your profile picture has been updated successfully']);
   }
 }
}


function changePassword(Request $request){

    if(!auth()->user()->can('edit_profile')) {
        abort(403, 'Unauthorized Action');
    }

           //Validate form
 $validator = \Validator::make($request->all(),[
   'oldpassword'=>[
     'required', function($attribute, $value, $fail){
       if( !\Hash::check($value, Auth::user()->password) ){
         return $fail(__('The current password is incorrect'));
       }
     },
     'min:8',
     'max:30'
   ],
   'newpassword'=>'required|min:8|max:30',
   'cnewpassword'=>'required|same:newpassword'
 ],[
  'oldpassword.required'=>'Enter your current password',
  'oldpassword.min'=>'Old password must have atleast 8 characters',
  'oldpassword.max'=>'Old password must not be greater than 30 characters',
  'newpassword.required'=>'Enter new password',
  'newpassword.min'=>'New password must have atleast 8 characters',
  'newpassword.max'=>'New password must not be greater than 30 characters',
  'cnewpassword.required'=>'ReEnter your new password',
  'cnewpassword.same'=>'New password and Confirm new password must match'
]);

 if( !$validator->passes() ){
   return response()->json(['status'=>0,'error'=>$validator->errors()->toArray()]);
 }else{

  $update = User::findOrFail(Auth::user()->id)->update(['password'=>\Hash::make($request->newpassword)]);

  if( !$update ){
    return response()->json(['status'=>0,'msg'=>'Something went wrong, Failed to update password in db']);
  }else{
    return response()->json(['status'=>1,'msg'=>'Your password has been changed successfully']);
  }
}
}
}
