@extends('dashboards.guest.layouts.guest_layout')

@section('title', 'Home')

@section('content')
    <!-- ======= Hero Section ======= -->
    <section id="hero" class="d-flex justify-cntent-center align-items-center">
        <div id="heroCarousel" data-bs-interval="5000" class="container carousel carousel-fade" data-bs-ride="carousel">

            <!-- Slide 1 -->
            <div class="carousel-item active">
                <div class="carousel-container">
                    <h2 class="animate__animated animate__fadeInDown">Welcome to <span>T-Link FTTH</span></h2>
                    <p class="animate__animated animate__fadeInUp">T-link FTTH အသုံးပြုခြင်းဖြင့် ကမ္ဘာကြီး၏
                        သတင်းအချက်အလက်များ နေ့စဉ်မပျက် သိရှိနိုင်ခြင်းနှင့် ပညာရပ်ပိုင်းဆိုင်ရာများ ပိုမိုလေ့လာနိုင်မည်
                        ဖြစ်ပါသည်။</p>
                    <a href="#about" class="btn-get-started animate__animated animate__fadeInUp scrollto">Read More</a>
                </div>
            </div>

            <!-- Slide 2 -->
            <div class="carousel-item">
                <div class="carousel-container">
                    <h2 class="animate__animated animate__fadeInDown">FTTH (Fiber To The Home)</h2>
                    <p class="animate__animated animate__fadeInUp">FTTH (Fiber To The Home) ဆိုသည်မှာ သင်၏အိမ်သို့
                        မြန်နှုန်းမြှင့် အင်တာနက်အား Fiber Cable ဖြင့် သွယ်တန်း၍ အင်တာနက်အား Data Unlimited
                        အသုံးပြုနိုင်ခြင်း ဖြစ်သည်။ ယခုအခါ ဝမ်းတွင်း သဲတောသို့ မြန်နှုန်းမြင့် အင်တာနက်များ တပ်ဆင်ရန် T-Link
                        FTTH မှ ဝန်ဆောင်မှု ရရှိနိုင်ပါသည်။</p>
                    <a href="#about" class="btn-get-started animate__animated animate__fadeInUp scrollto">Read More</a>
                </div>
            </div>

            <!-- Slide 3 -->
            <div class="carousel-item">
                <div class="carousel-container">
                    <h2 class="animate__animated animate__fadeInDown">Advantages</h2>
                    <p class="animate__animated animate__fadeInUp">T-Link FTTH အသုံးပြုခြင်းဖြင့် Mobile Data ဘေလ် သက်သာစွာ
                        နေ့စဉ် Connection Lag ခြင်းမရှိဘဲ Game ကစားနိုင်ခြင်းနှင့် Movie များ အထစ်ငေါ့မရှိ ကြည့်ရှု့နိုင်မည်
                        ဖြစ်ပါသည်။</p>
                    <a href="#about" class="btn-get-started animate__animated animate__fadeInUp scrollto">Read More</a>
                </div>
            </div>

            <a class="carousel-control-prev" href="#heroCarousel" role="button" data-bs-slide="prev">
                <span class="carousel-control-prev-icon bx bx-chevron-left" aria-hidden="true"></span>
            </a>

            <a class="carousel-control-next" href="#heroCarousel" role="button" data-bs-slide="next">
                <span class="carousel-control-next-icon bx bx-chevron-right" aria-hidden="true"></span>
            </a>

        </div>
    </section><!-- End Hero -->

    <main id="main" class="tagu">
        <!-- ======= Icon Boxes Section ======= -->
        <section class="mt-5">
            <div class="container">
                <div class="section-title">
                    <h2>Service Areas</h2>
                </div>
                <div class="row tagu justify-content-end">
                    @forelse($servicea as $s)
                        <div class="col-md-6 col-lg-4 d-flex align-items-stretch mb-5 mb-lg-0" data-aos="fade-up">
                            <div class="card servicea">
                                <div class="inner">
                                    <img src="{{ $s->servicea_path() }}" class="card-img-top" alt="...">
                                </div>
                                <div class="card-body">
                                    <h5 class="card-title tagu" style="font-size: 16px; font-weight: bold;">
                                        {{ $s->name }}</h5>
                                    <hr>
                                    <p class="card-text tagu" style="font-size: 14px;">{!! $s->description !!}</p>
                                    <hr>
                                    <a href="{{ route('t-link-service-area.show', $s->slug) }}" class="btn btn-outline-primary btn-sm">More Detail</a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p>No Service Area Found!</p>
                    @endforelse
                </div>

            </div>
        </section><!-- End Icon Boxes Section -->

        <!-- ======= Pricing Section ======= -->
        {{-- <section id="pricing" class="pricing">
            <div class="container" data-aos="fade-up">

                <div class="section-title">
                    <h2 class="mb-5">Our Plans</h2>

                    <h3 class="tagu">သဲတော/ဝမ်းတွင်း</h3>
                    <p>သင်၏နေအိမ်အရောက် Fiber Cable ဖြင့် မြန်နှုန်းမြင့် အကန့်အသတ်မဲ့ အင်တာနက်လိုင်းများအား အကောင်းဆုံး
                        ဝန်ဆောင်မှုဖြင့် သဲတော/ဝမ်းတွင်းသို့ ရောက်ရှိလာပါပြီ။</p>
                </div>

                <div class="row">

                    <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                        <div class="box featured">
                            <h3>Plan A</h3>
                            <h4>10Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 35000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 87000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 174000ks</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-md-0" data-aos="fade-up" data-aos-delay="200">
                        <div class="box">
                            <h3>Plan B</h3>
                            <h4>20Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 111000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 199800ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <span class="advanced">For Business</span>
                            <h3>Plan C</h3>
                            <h4>30Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 111000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 199800ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>

                        </div>
                    </div>
                    <div class="col-md-12 mt-5" style="font-weight: bold;">
                        <li>တပ်ဆင်ခ ၂၀၀၀၀ကျပ် (တစ်ကြိမ်သာ)</li>
                        <li>(၃)လ နှင့် (၃)လ အထက် ဝယ်ယူအသုံးပြုသူများအား တပ်ဆင်ခ အခမဲ့ဖြင့် အသုံးပြုနိုင်ပါသည်။</li>
                    </div>
                </div>

                <div class="section-title mt-5">

                    <h3 class="tagu">ကူမဲ</h3>
                    <p>သင်၏နေအိမ်အရောက် Fiber Cable ဖြင့် မြန်နှုန်းမြင့် အကန့်အသတ်မဲ့ အင်တာနက်လိုင်းများအား အကောင်းဆုံး
                        ဝန်ဆောင်မှုဖြင့် ကူမဲမြို့သို့ ရောက်ရှိလာပါပြီ။</p>
                </div>

                <div class="row">
                    <div class="col-lg-4 col-md-6 mb-3" data-aos="fade-up" data-aos-delay="100">
                        <div class="box featured">
                            <h3>Plan A</h3>
                            <h4>15Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 00000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 00000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 00000ks</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-md-0 mb-3" data-aos="fade-up" data-aos-delay="200">
                        <div class="box">
                            <h3>Plan B</h3>
                            <h4>20Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 111000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 199800ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့ + ၁၀% Discount</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <h3>Plan C</h3>
                            <h4>30Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 111000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 199800ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့ + ၁၀% Discount</li>
                            </ul>

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <span class="advanced">For Business</span>
                            <h3>Plan D</h3>
                            <h4>40Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့ + ၁၀% Discount</li>
                            </ul>

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <span class="advanced">For Business</span>
                            <h3>Plan E</h3>
                            <h4>50Mb<span>/s</span></h4>
                            <ul>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၆လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့ + ၁၀% Discount</li>
                            </ul>

                        </div>
                    </div>


                    <div class="col-md-12 mt-5" style="font-weight: bold;">
                        <li>တပ်ဆင်ခ ၂၅၀၀၀ကျပ် (တစ်ကြိမ်သာ)</li>
                        <li>(၃)လ နှင့် (၃)လ အထက် ဝယ်ယူအသုံးပြုသူများအား တပ်ဆင်ခ အခမဲ့ဖြင့် အသုံးပြုနိုင်ပါသည်။</li>
                    </div>
                </div>


                <div class="section-title mt-5">

                    <h3 class="tagu">နွားထိုးကြီး</h3>
                    <p>သင်၏နေအိမ်အရောက် Fiber Cable ဖြင့် မြန်နှုန်းမြင့် အကန့်အသတ်မဲ့ အင်တာနက်လိုင်းများအား အကောင်းဆုံး
                        ဝန်ဆောင်မှုဖြင့် နွားထိုးကြီးမြို့သို့ ရောက်ရှိလာပါပြီ။</p>
                </div>

                <div class="row">
                    <div class="col-lg-4 col-md-6 mb-3" data-aos="fade-up" data-aos-delay="100">
                        <div class="box featured">
                            <h3>Plan A</h3>
                            <h4>14Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 28000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 00000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 00000ks</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-md-0 mb-3" data-aos="fade-up" data-aos-delay="200">
                        <div class="box">
                            <h3>Plan B</h3>
                            <h4>22Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 34000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၃လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့ + ၁၀% Discount</li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <h3>Plan C</h3>
                            <h4>27Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 41000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 111000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 199800ks</li>
                                <br>
                                <li style="color: red;">၃လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <h3>Plan D</h3>
                            <h4>33Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 49000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၃လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <span class="advanced">For Business</span>
                            <h3>Plan E</h3>
                            <h4>44Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 59000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၃လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 mt-4 mt-lg-0 mb-3" data-aos="fade-up" data-aos-delay="400">
                        <div class="box">
                            <span class="advanced">For Business</span>
                            <h3>Plan F</h3>
                            <h4>55Mb<span>/s</span></h4>
                            <ul>
                                <li>၁လချင်းသွင်းလျှင် - 69000ks</li>
                                <li>၃လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <li>၆လ ကြိုတင်သွင်းငွေ - 000000ks</li>
                                <br>
                                <li style="color: red;">၃လ ကြိုတင်ဝယ်ယူလျှင် တပ်ဆင်ခ အခမဲ့</li>
                            </ul>

                        </div>
                    </div>



                    <div class="col-md-12 mt-5" style="font-weight: bold;">
                        <li>တပ်ဆင်ခ ၂၀၀၀၀ကျပ် (တစ်ကြိမ်သာ)</li>
                        <li>(၃)လ နှင့် (၃)လ အထက် ဝယ်ယူအသုံးပြုသူများအား တပ်ဆင်ခ အခမဲ့ဖြင့် အသုံးပြုနိုင်ပါသည်။</li>
                    </div>
                </div>

            </div>
        </section><!-- End Pricing Section --> --}}

        <!-- ======= About Us Section ======= -->
        <section id="about" class="about">
            <div class="container" data-aos="fade-up">

                <div class="section-title">
                    <h2>About Us</h2>
                    <p>T-link FTTH အသုံးပြုခြင်းဖြင့် ကမ္ဘာကြီး၏ သတင်းအချက်အလက်များ နေ့စဉ်မပျက် သိရှိနိုင်ခြင်းနှင့်
                        ပညာရပ်ပိုင်းဆိုင်ရာများ ပိုမိုလေ့လာနိုင်မည် ဖြစ်ပါသည်။</p>
                </div>

                <div class="row content">
                    <div class="col-lg-6">
                        <p>
                            FTTH (Fiber To The Home) ဆိုသည်မှာ သင်၏အိမ်သို့ မြန်နှုန်းမြှင့် အင်တာနက်အား Fiber Cable ဖြင့်
                            သွယ်တန်း၍ အင်တာနက်အား Data Unlimited အသုံးပြုနိုင်ခြင်း ဖြစ်သည်။ ယခုအခါ ဝမ်းတွင်း သဲတောသို့
                            မြန်နှုန်းမြင့် အင်တာနက်များ တပ်ဆင်ရန် T-Link FTTH မှ ဝန်ဆောင်မှု ရရှိနိုင်ပါသည်။
                        </p>
                        <ul>
                            <li><i class="ri-check-double-line"></i> Ullamco laboris nisi ut aliquip ex ea commodo consequat
                            </li>
                            <li><i class="ri-check-double-line"></i> Duis aute irure dolor in reprehenderit in voluptate
                                velit</li>
                            <li><i class="ri-check-double-line"></i> Ullamco laboris nisi ut aliquip ex ea commodo consequat
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-6 pt-4 pt-lg-0">
                        <p>
                            T-Link FTTH အသုံးပြုခြင်းဖြင့် Mobile Data ဘေလ် သက်သာစွာ နေ့စဉ် Connection Lag ခြင်းမရှိဘဲ Game
                            ကစားနိုင်ခြင်းနှင့် Movie များ အထစ်ငေါ့မရှိ ကြည့်ရှု့နိုင်မည် ဖြစ်ပါသည်။
                        </p>
                        <a href="#" class="btn-learn-more">Learn More</a>
                    </div>
                </div>

            </div>
        </section><!-- End About Us Section -->

        <!-- ======= Services Section ======= -->
        <section id="services" class="services">
            <div class="container" data-aos="fade-up">

                <div class="section-title">
                    <h2>Services</h2>
                    <p>Magnam dolores commodi suscipit. Necessitatibus eius consequatur ex aliquid fuga eum quidem. Sit sint
                        consectetur velit. Quisquam quos quisquam cupiditate. Et nemo qui impedit suscipit alias ea. Quia
                        fugiat sit in iste officiis commodi quidem hic quas.</p>
                </div>

                <div class="row">
                    <div class="col-md-6 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="100">
                        <div class="icon-box">
                            <i class="bi bi-card-checklist"></i>
                            <h4><a href="#">
                                    FTTH ဝန်ဆောင်မှု</a></h4>
                            <p>Voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati
                                cupiditate non provident</p>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex align-items-stretch mt-4 mt-md-0" data-aos="fade-up" data-aos-delay="200">
                        <div class="icon-box">
                            <i class="bi bi-bar-chart"></i>
                            <h4><a href="#">
                                    Fibers လုပ်ငန်းများ</a></h4>
                            <p>Minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
                                consequat tarad limino ata</p>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex align-items-stretch mt-4 mt-md-0" data-aos="fade-up" data-aos-delay="300">
                        <div class="icon-box">
                            <i class="bi bi-binoculars"></i>
                            <h4><a href="#">နည်းပညာနှင့် ပတ်သတ်သည့်လုပ်ငန်းများ</a></h4>
                            <p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla
                                pariatur</p>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex align-items-stretch mt-4 mt-md-0" data-aos="fade-up" data-aos-delay="400">
                        <div class="icon-box">
                            <i class="bi bi-brightness-high"></i>
                            <h4><a href="#">
                                    Websites ရေးဆွဲခြင်းလုပ်ငန်းများ</a></h4>
                            <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit
                                anim id est laborum</p>
                        </div>
                    </div>

                </div>

            </div>
        </section><!-- End Services Section -->

        <!-- ======= Contact Section ======= -->
        <section id="contact" class="contact">
            <div class="container" data-aos="fade-up">

                <div class="section-title">
                    <h2>Contact Us</h2>
                </div>

                <div class="row mt-1 d-flex justify-content-start" data-aos="fade-right" data-aos-delay="100">

                    <div class="col-lg-5">
                        <div class="info">
                            <div class="address">
                                <i class="bi bi-geo-alt"></i>
                                <h4>Location:</h4>
                                @foreach ($servicea as $sva)
                                    <div>
                                        <p class="mb-1" style="font-weight: bold;">{{ $sva->name }}</p>
                                        <p>{!! $sva->address !!}</p>
                                        <hr>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                    <div class="col-lg-3">
                        <div class="info">
                            <div class="address">
                                <i class="bi bi-envelope"></i>
                                <h4>Email:</h4>
                                <p>info@t-linkftth.com</p>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-4">
                        <div class="info">
                            <div class="address">
                                <i class="bi bi-phone"></i>
                                <h4>Call:</h4>
                                @foreach ($servicea as $sva)
                                    <div>
                                        <p class="mb-1" style="font-weight: bold;">{{ $sva->name }}</p>
                                        <p>
                                            {{ $sva->phone1 }}
                                            @if ($sva->phone2)
                                                , {{ $sva->phone2 }}
                                            @endif
                                            @if ($sva->phone3)
                                                , {{ $sva->phone3 }}
                                            @endif
                                        </p>
                                        <hr>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                    </div>

                    {{-- <div class="col-lg-6 mt-5 mt-lg-0" data-aos="fade-left" data-aos-delay="100">

                        <form action="forms/contact.php" method="post" role="form" class="php-email-form">
                            <div class="row">
                                <div class="col-md-6 form-group">
                                    <input type="text" name="name" class="form-control" id="name" placeholder="Your Name"
                                        required>
                                </div>
                                <div class="col-md-6 form-group mt-3 mt-md-0">
                                    <input type="email" class="form-control" name="email" id="email"
                                        placeholder="Your Email" required>
                                </div>
                            </div>
                            <div class="form-group mt-3">
                                <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject"
                                    required>
                            </div>
                            <div class="form-group mt-3">
                                <textarea class="form-control" name="message" rows="5" placeholder="Message"
                                    required></textarea>
                            </div>
                            <div class="my-3">
                                <div class="loading">Loading</div>
                                <div class="error-message"></div>
                                <div class="sent-message">Your message has been sent. Thank you!</div>
                            </div>
                            <div class="text-center"><button type="submit">Send Message</button></div>
                        </form>

                    </div> --}}

                </div>

            </div>
        </section><!-- End Contact Section -->

    </main><!-- End #main -->



@endsection

@section('scripts')

@endsection
