<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>T-Link FTTH | @yield('title')</title>
    <!-- <base href="{{ \URL::to('/') }}"> -->
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}">


    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('back/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('back/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('back/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('back/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
    <!-- /DataTables -->
    <link rel="stylesheet" href="{{ asset('back/plugins/ijaboCropTool/ijaboCropTool.min.css') }}">
    <!-- sweetalert2 -->
    <link rel="stylesheet" href="{{ asset('back/plugins/sweetalert2/sweetalert2.min.css') }}">
    {{-- daterangepicker css --}}
    <link rel="stylesheet" href="{{ asset('back/plugins/daterangepicker/daterangepicker.css') }}">
    <!-- light box css -->
    <link rel="stylesheet" href="{{ asset('back/plugins/lightbox/css/lightbox.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('back/dist/css/adminlte.min.css') }}">
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/admincustom.css') }}" rel="stylesheet">
    <style>
        @font-face {
            font-family: Pyidaungsu;
            src: url('/fonts/Pyidaungsu.eot');
            src: local('☺'), url('/fonts/Pyidaungsu.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        .tagu {
            font-family: "Pyidaungsu" !important;
        }

        label:not(.form-check-label):not(.custom-file-label) {
            font-weight: normal;
        }

        .nav-icon {
            color: #96ed90;
        }

        /* -----------------action icon ---------------*/
        .action-icon a {
            padding: 5px;
            background-color: #eee;
            border-radius: 5px;
            width: 32px;
            height: 32px;
            line-height: 25px;
            display: inline-block;
            margin: 3px !important;
        }

        /*-----------preview image -----------------*/
        .preview_img img {
            width: 100px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }

        .profile-img {
            width: 100px;
            height: 100px;
            border-radius: 100%;
            border: 1px solid #5cb85c;
            padding: 3px;
        }

        .profile-thumbnail {
            width: 70px;
            height: 70px;
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 3px;
        }

        .dash-border {
            border-left: 2px dotted #ddd;
        }

        .nav-link p, .sidebar .user-panel .info {
            transition: margin-left .3s linear,opacity .3s ease,visibility .3s ease;
            font-size: 14px;
          }

    </style>
    @yield('styles')

</head>

<body class="hold-transition sidebar-mini layout-fixed tagu">
    <div class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a target="_blank" class="nav-link" href="{{ route('/') }}"
                        class="nav-link {{ request()->is('/') ? 'active' : '' }}">
                        Visit Site
                    </a>
                </li>

                {{-- <li class="nav-item d-none d-sm-inline-block">
                    <a class="nav-link" href="{{ route('profile') }}"
                        class="nav-link {{ set_active(['profile']) }}">
                        Profile
                    </a>
                </li> --}}

                <li class="nav-item d-none d-sm-inline-block">
                    <a class="nav-link" href="{{ route('logout') }}" onclick="event.preventDefault();
          document.getElementById('logout-form').submit();">
                        {{ __('Logout') }}
                    </a>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </li>
            </ul>


        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="{{ route('/') }}" class="brand-link">
                <img src="{{ asset('img/tlinkbacklogo.png') }}" alt="AdminLTE Logo" class="brand-image elevation-3"
                    style="opacity: .8">
                <span class="brand-text"><strong style="color: cyan;">T-Link FTTH</strong></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="{{ Auth::user()->profile_img_path() }}" class="img-circle elevation-2 admin_picture"
                            alt="User Image">
                    </div>
                    <div class="info">
                        <a href="#" class="d-block admin_name">{{ Auth::user()->name }}</a>
                    </div>
                </div>



                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-item">
                            <a href="{{ route('admin.dashboard') }}"
                                class="nav-link {{ set_active(['admin.dashboard']) }}">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>
                                    Dashboard
                                </p>
                            </a>
                        </li>
                        @can('view_user')
                            <li class="nav-item">
                                <a href="{{ route('employee.index') }}"
                                    class="nav-link {{ set_active(['employee.index']) }}">
                                    <i class="nav-icon fas fa-users"></i>
                                    <p>
                                        Users
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_role')
                            <li class="nav-item">
                                <a href="{{ route('role.index') }}" class="nav-link {{ set_active(['role.index']) }}">
                                    <i class="nav-icon fas fa-user-shield"></i>
                                    <p>
                                        Roles
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_permission')
                            <li class="nav-item">
                                <a href="{{ route('permission.index') }}"
                                    class="nav-link {{ set_active(['permission.index']) }}">
                                    <i class="nav-icon fas fa-shield-alt"></i>
                                    <p>
                                        Permissions
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_service_area')
                            <li class="nav-item">
                                <a href="{{ route('servicearea.index') }}"
                                    class="nav-link {{ set_active(['servicearea.index']) }}">
                                    <i class="nav-icon fas fa-map-marker-alt"></i>
                                    <p>
                                        Service Areas
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_service_plan')
                            <li class="nav-item">
                                <a href="{{ route('plan.index') }}"
                                    class="nav-link {{ set_active(['plan.index']) }}">
                                    <i class="nav-icon fas fa-columns"></i>
                                    <p>
                                        Service Plans
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_blog')
                            <li class="nav-item">
                                <a href="{{ route('blog.index') }}" class="nav-link">
                                    <i class="nav-icon fas fa-newspaper"></i>
                                    <p>
                                        Blogs
                                    </p>
                                </a>
                            </li>
                        @endcan
                        @can('view_blog-category')
                            <li class="nav-item">
                                <a href="{{ route('blogcategory.index') }}" class="nav-link">
                                    <i class="nav-icon fas fa-tags"></i>
                                    <p>
                                        Blog Categories
                                    </p>
                                </a>
                            </li>
                        @endcan

                        @can('view_profile')
                        <li class="nav-item">
                            <a href="{{ route('admin.profile') }}"
                                class="nav-link {{ set_active(['admin.profile']) }}">
                                <i class="nav-icon far fa-address-card"></i>
                                <p>
                                    Profile
                                </p>
                            </a>
                        </li>
                        @endcan
                        <!--  <li class="nav-item">
          <a href="{{ route('admin.settings') }}" class="nav-link {{ request()->is('admin/settings*') ? 'active' : '' }}">
            <i class="nav-icon fas fa-cog"></i>
            <p>
             Logout
           </p>
         </a>
       </li> -->
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            @yield('content')
        </div>
        <!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
            <div class="p-3">
                <h5>Title</h5>
                <p>Sidebar content</p>
            </div>
        </aside>
        <!-- /.control-sidebar -->

        <!-- Main Footer -->
        <footer class="main-footer">
            <!-- To the right -->
            <div class="float-right d-none d-sm-inline">
                Anything you want
            </div>
            <!-- Default to the left -->
            <strong>Copyright &copy; {{ date('Y') }} <a href="{{ route('/') }}">SuLatPaing
                    Co.,Ltd.</a>.</strong> All rights reserved.
        </footer>
    </div>
    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="{{ asset('back/plugins/jquery/jquery.min.js') }}"></script>
    <!-- Bootstrap 4 -->
    <script src="{{ asset('back/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- lightbox JS -->
    <script src="{{ asset('back/plugins/lightbox/js/lightbox-plus-jquery.min.js') }}"></script>
    <!-- DataTables  & Plugins -->
    <script src="{{ asset('back/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('back/plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('back/plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('back/plugins/pdfmake/vfs_fonts.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('back/plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>
    <!-- /DataTables -->
    <script src="{{ asset('back/plugins/ijaboCropTool/ijaboCropTool.min.js') }}"></script>
    <script src="{{ asset('js/sweetalert2.min.js') }}"></script>
    {{--  daterange picker  --}}
    <script type="text/javascript" src="{{ asset('back/plugins/daterangepicker/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('back/plugins/daterangepicker/daterangepicker.js') }}"></script>
    {{-- sweetalert1 --}}
    <script src="{{ asset('js/sweetalert1.min.js') }}"></script>
    <!-- ChartJS -->
    <script src="{{ asset('back/plugins/chart.js/Chart.min.js') }}"></script>

    <!-- AdminLTE App -->
    <script src="{{ asset('back/dist/js/adminlte.min.js') }}"></script>
    <!-- Laravel Javascript Validation -->
    <script type="text/javascript" src="{{ url('vendor/jsvalidation/js/jsvalidation.js') }}"></script>

    <!-- AdminLTE App -->
    <script src="{{ asset('js/select2.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/script.js') }}"></script>

    @yield('scripts')
    {{-- CUSTOM JS CODES --}}
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(function() {

            /* UPDATE ADMIN PERSONAL INFO */

            $('#AdminInfoForm').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    dataType: 'json',
                    contentType: false,
                    beforeSend: function() {
                        $(document).find('span.error-text').text('');
                    },
                    success: function(data) {
                        if (data.status == 0) {
                            $.each(data.error, function(prefix, val) {
                                $('span.' + prefix + '_error').text(val[0]);
                            });
                        } else {
                            $('.admin_name').each(function() {
                                $(this).html($('#AdminInfoForm').find($(
                                    'input[name="name"]')).val());
                            });
                            swal("Good job!", "You clicked the button!", "success")

                            .then(function() {
                                location.reload();
                            });
                                        }
                    }
                });
            });



            $(document).on('click', '#change_picture_btn', function() {
                $('#admin_image').click();
            });


            $('#admin_image').ijaboCropTool({
                preview: '.admin_picture',
                setRatio: 1,
                allowedExtensions: ['jpg', 'jpeg', 'png'],
                buttonsText: ['CROP', 'QUIT'],
                buttonsColor: ['#30bf7d', '#ee5155', -15],
                processUrl: '{{ route('adminPictureUpdate') }}',
                // withCSRF:['_token','{{ csrf_token() }}'],
                onSuccess: function(message, element, status) {
                    swal("Good job!", "You clicked the button!", "success")

                    .then(function() {
                        location.reload();
                    });
                },
                onError: function(message, element, status) {
                    alert(message);
                }
            });


            $('#changePasswordAdminForm').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    dataType: 'json',
                    contentType: false,
                    beforeSend: function() {
                        $(document).find('span.error-text').text('');
                    },
                    success: function(data) {
                        if (data.status == 0) {
                            $.each(data.error, function(prefix, val) {
                                $('span.' + prefix + '_error').text(val[0]);
                            });
                        } else {
                            $('#changePasswordAdminForm')[0].reset();
                            swal("Good job!", "You clicked the button!", "success")

                            .then(function() {
                                location.reload();
                            });
                        }
                    }
                });
            });

            @if(session('create'))
                Swal.fire({
                    title: 'Successfully Created!',
                    text: '{{ session('create') }}',
                    icon: 'success',
                })
            @endif

            @if(session('update'))
                Swal.fire({
                    title: 'Successfully Updated!',
                    text: '{{ session('update') }}',
                    icon: 'success',
                })
            @endif

            $('.select-ninja').select2();
        });
    </script>
</body>

</html>
