<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\BlogCategory;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use App\Http\Requests\StoreBlogCategory;
use App\Http\Requests\UpdateBlogCategory;

class BlogCategoryController extends Controller
{
    public function index()
    {
        if(!auth()->user()->can('view_blog_category')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.blogcategory.index');
    }

    public function ssd(Request $request)
    {
        if(!auth()->user()->can('view_blog_category')) {
            abort(403, 'Unauthorized Action');
        }

        $category = BlogCategory::query();

        return Datatables::of($category)
            ->editColumn('updated_at', function($each) {
                return Carbon::parse($each->updated_at)->format('Y-m-d H:i:s');
            })
            ->addColumn('action', function($each) {
                $edit_icon = '<a href="' . route('blogcategory.edit', $each->id) . '" class="text-warning"><i class="far fa-edit"></i></a>';
                $delete_icon = '<a href="#" class="text-danger delete-btn" data-id="'. $each->id .'"><i class="fas fa-trash-alt"></i></a>';

                return '<div class="action-icon">' . $edit_icon . $delete_icon.'</div>';
            })
            ->addColumn('plus-icon', function($each) {
                return null;
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function create()
    {
        if(!auth()->user()->can('create_blog_category')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.blogcategory.create');
    }

    public function store(StoreBlogCategory $request)
    {
        if(!auth()->user()->can('create_department')) {
            abort(403, 'Unauthorized Action');
        }
        $slug = uniqid();
        $category = new BlogCategory();
        $category->name = $request->name;
        $category->slug = $slug;
        $category->save();

        return redirect()->route('blogcategory.index')->with('create', 'Blog Category is successfully Create!');
    }

    public function edit($id)
    {
        if(!auth()->user()->can('edit_blog_category')) {
            abort(403, 'Unauthorized Action');
        }
        $category = BlogCategory::findOrFail($id);
        return view('dashboards.admins.blogcategory.edit', compact('category'));
    }

    public function update($id, UpdateBlogCategory $request)
    {
        if(!auth()->user()->can('edit_blog_category')) {
            abort(403, 'Unauthorized Action');
        }

        $category = BlogCategory::findOrFail($id);

        $category->name = $request->name;
        $category->update();

        return redirect()->route('blogcategory.index')->with('update', 'Blog Category is successfully Update!');
    }


    public function destroy($id)
    {
        if(!auth()->user()->can('delete_blog_category')) {
            abort(403, 'Unauthorized Action');
        }

        $category = BlogCategory::findOrFail($id);
        $category->delete();

        return 'success';
    }
}
